//=============================================================================
// AmmoShell.
//=============================================================================
class AmmoSniper extends DeusExAmmo;

#exec OBJ LOAD FILE=CoreTexGlass

#exec MESH IMPORT MESH=SniperAmmo ANIVFILE=MODELS\SniperAmmo_a.3d DATAFILE=MODELS\SniperAmmo_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SniperAmmo X=0 Y=0 Z=100 PITCH=0 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=SniperAmmo SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SniperAmmo SEQ=SniperAmmo STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=SniperAmmo MESH=SniperAmmo
#exec MESHMAP SCALE MESHMAP=SniperAmmo X=0.01933655625 Y=0.01933655625 Z=0.01933655625

#exec TEXTURE IMPORT FILE="Textures\CBAGray.pcx"	NAME="SniperAGray"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBAGold.pcx"	NAME="SniperAGold"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\CBADGold.pcx"	NAME="SniperADGold"	GROUP="Icons" MIPS=Off

#exec MESHMAP SETTEXTURE MESHMAP=SniperAmmo NUM=0 TEXTURE=SniperAGray
#exec MESHMAP SETTEXTURE MESHMAP=SniperAmmo NUM=1 TEXTURE=SniperAGold
#exec MESHMAP SETTEXTURE MESHMAP=SniperAmmo NUM=2 TEXTURE=SniperADGold


function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing shell;
	local DeusExWeapon W;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		// use silent shells if the weapon has been silenced
		W = DeusExWeapon(Pawn(Owner).Weapon);
      if ((DeusExMPGame(Level.Game) != None) && (!DeusExMPGame(Level.Game).bSpawnEffects))
      {
         shell = None;
      }
      else
      {
         if ((W != None) && ((W.NoiseLevel < 0.1) || W.bHasSilencer))
            shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
         else
            shell = spawn(class'ShellCasing',,, Owner.Location + offset);
      }

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}

	return False;
}

defaultproperties
{
     Texture=Texture'07WindOpacStrek'
     bShowInfo=True
     AmmoAmount=6
     MaxAmmo=192
     ItemName="Sniper Rifle Rounds"
     ItemArticle="some"
     PickupViewMesh=LodMesh'SniperAmmo'
     Icon=Texture'DeusExUI.Icons.BeltIconAmmo3006'
     largeIconWidth=0
     largeIconHeight=0
     Description=""
     beltDescription=""
     Mesh=LodMesh'SniperAmmo'
     CollisionRadius=2.500000
     CollisionHeight=2.000000
     bCollideActors=True
     DrawScale=0.800000
     PickupViewScale=0.800000
}
